#ifndef KMS_UTIL_LOGGER_H
#define KMS_UTIL_LOGGER_H

#include <stdarg.h>


typedef enum
{
	LOGGER_LEVEL_NONE=0,
	LOGGER_LEVEL_ERROR,
	LOGGER_LEVEL_INFO,
	LOGGER_LEVEL_DEBUG,
	LOGGER_LEVEL_UNSET
} __attribute__((packed)) logger_loglevel_t;

void logger_init(logger_loglevel_t min_level);

void logger_log_error(const char *message, ...);

void logger_log_info(const char *message, ...);

void logger_log_debug(const char *message, ...);

void logger_vlog_error(const char *fmt, va_list args);

void logger_vlog_info(const char *fmt, va_list args);

void logger_vlog_debug(const char *fmt, va_list args);

#endif
